/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.mcef.utilities;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;

public final class Util {
    public static String sha1Hash(File file) throws IOException, NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        try (FileInputStream input = new FileInputStream(file);){
            byte[] buffer = new byte[8192];
            int len = ((InputStream)input).read(buffer);
            while (len != -1) {
                md.update(buffer, 0, len);
                len = ((InputStream)input).read(buffer);
            }
            StringBuilder result = new StringBuilder();
            for (byte b : md.digest()) {
                result.append(String.format("%02x", b));
            }
            String string = result.toString();
            return string;
        }
    }

    public static void makeExecNix(File file) {
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        perms.add(PosixFilePermission.OWNER_READ);
        perms.add(PosixFilePermission.OWNER_WRITE);
        perms.add(PosixFilePermission.OWNER_EXECUTE);
        try {
            Files.setPosixFilePermissions(file.toPath(), perms);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

